clear;
clc;
close;

function freqdist(x,xclass)
    [m n]=size(x);            //sample size
    [m nB]=size(xclass);      //no.of class boundaries
    k=nB - 1;
    
    cmark = zeros(1,k);
    for ii = 1:k
        cmark(ii) = 0.5*(xclass(ii)+xclass(ii+1));
    end
    
    fcount=zeros(2,k);
    fbelow=0;
    fabove=0;
    
    for ii=1:n
        if x(ii) < xclass(1)
            fbelow = fbelow + 1;
        elseif x(ii) > xclass(nB)
            fabove = fabove + 1;
        else
            for jj = 1:k
                if x(ii)>= xclass(jj) & x(ii)< xclass(jj+1)
                    fcount(jj) = fcount(jj) +1;
                end
            end
        end
    end
    
    frel=fcount/n
    
    fcumul = zeros(1,k);
    fcumul(1) = fcount(1);
    for ii = 2:k
        fcumul(ii) = fcumul(ii-1) + fcount(ii);
    end;
    
    fcumulrel = fcumul/n;
    
    mprintf('\n -------------------------------------------------------------------------------------------------------');
    mprintf('\nFrequency distribution');
    mprintf('\n -------------------------------------------------------------------------------------------------------');
    mprintf('\n  Class\tLowBound\tUpBound\t\tClass Mark\tFreq.\t\tRelFreq.\tCumFreq.\tRelCumFreq.');
    mprintf('\n -------------------------------------------------------------------------------------------------------');
    for ii = 1:k
        mprintf('\n%5.0f\t%10.6g\t%10.6g\t%10.6g\t%10.6g\t%10.6g\t%10.6g\t%10.6g\t\n',ii,xclass(ii),xclass(ii+1),cmark(ii),fcount(ii),frel(ii),fcumul(ii),fcumulrel(ii))
    end
    disp('\n -------------------------------------------------------------------------------------------------------');
    disp(' ')
    
    if fbelow ~= 0
        mprintf('Outliers below minimum class boundary = %10.6g \n',fbelow)
    end
    if fabove ~= 0
        mprintf('Outliers above maximum class boundary = %10.6g \n',fabove)
    end
    mprintf('Total no of data points = %10.6g \n',n);
    mprintf('Total no of classes = %10.6g \n',k);
    
    disp(' ');
    
    xset('window',1);
    histplot(k,x);
    xtitle('histogram','x','rel.f');
    xset('window',2);
    xset('mark',-9,2);
    plot2d(cmark,fcumulrel,-9);
    plot2d(cmark,fcumulrel,1);
    xtitle('ogive','x','cum.rel.f');
endfunction
